package easik.sketch.constraint;

import java.util.ArrayList;

import easik.sketch.path.SketchPath;


/** 
 * Class representing a pullback constraint.
 *
 * @author Kevin Green 2006
 * @author Vera Ranieri 2006
 * @version 2006-08-02 Kevin Green
 */
public class PullbackConstraint extends Constraint {

	/**
	 * Takes an ArrayList of paths, makes them a pullback.
	 * 
	 * @param inPaths An ArrayList of SketchPaths 
	 */
	public PullbackConstraint(ArrayList<SketchPath> inPaths){
		_constraintLabel = "PB";
		_isVisible = true;
		_paths = inPaths;
		addEdges();
	}
	
	/**
	 * Takes an ArrayList of paths, makes them a pullback.
	 * 
	 * @param paths An ArrayList of SketchPaths 
	 * @param x X coordinate of visual aid
	 * @param y Y coordinate of visual aid
	 * @param isVisible If the constraint is visible in the graph or not
	 */
	public PullbackConstraint(ArrayList<SketchPath> paths, int x, int y, boolean isVisible){
		super("PB", x, y, isVisible);
		
		_paths = paths;
		
		addEdges();
		_constraintLabel = "PB";
	}

	/**
	 * Method to determine whether a set of paths potentially forming a pullback constraint could legally
	 * form a pullback constraint.
	 * 
	 * Note: This method does not currently care about the order that the paths are selected.
	 * 
	 * @param paths The set of potential paths
	 * @return True if a legal pullback configuration, false otherwise.
	 * @since 2006-05-25 Vera Ranieri
	 */
	public static boolean isPullbackConstraint(ArrayList<SketchPath> paths){
		
		if(paths.size() !=4)
			return false;
		
		for(int i=0; i<4; i++){
			for(int j=0; j<4; j++){
				if(j != i)
				for(int k=0; k<4; k++){
					if(k != i && k != j)
					for(int l=0; l<4; l++){
						if(l != k && l != j && l!=i){
							SketchPath pathA = paths.get(i);
							SketchPath pathB = paths.get(j);
							SketchPath pathC = paths.get(k);
							SketchPath pathD = paths.get(l);
							try{
								if(pathA.getCoDomain().equals(pathB.getDomain()) && 
									pathB.getCoDomain().equals(pathD.getCoDomain()) &&
									pathA.getDomain().equals(pathC.getDomain()) &&
									pathC.getCoDomain().equals(pathD.getDomain()) &&
									pathA.getEdges().getFirst().getInjective() == pathD.getEdges().getFirst().getInjective() &&
									pathB.getEdges().getFirst().getInjective() == pathC.getEdges().getFirst().getInjective()){
									paths.clear();
									paths.add(pathA);
									paths.add(pathB);
									paths.add(pathC);
									paths.add(pathD);
									return true;
								}
							}
							catch(Exception e){
								//TODO: better way to determine whether there is a problem with the paths (i.e. 
								// there is a path of length 0)
								return false;
							}
						}
					}
				}
			}
		}
		
		return false;
	}

}
